﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public partial class Instructor : StatsBaseComponent
    {
        protected class ClassCompetencePartPanel : StatsPanel
        {
            public ClassCompetencePartPanel(StatsBaseComponent Component) : base(Component) { }

            public override void Load()
            {
                if (Component.Instructor != null && ClassID.HasValue && CompetenceID.HasValue)
                {
                    Component.AppendToXML(Component.Instructor);
                    BL.BO.Class _class = Component.BLELearning.Class.RestoreById(ClassID);
                    Component.AppendToXML(_class);

                    // to jest tak na prawde statystyka klasy - wiec powinien byc tylko jeden wpis
                    AppendToXML(Component.BLELearning.Statistic.StudentStatistic.Restore(_class));

                    // tutaj statystyka dla danej kompetencji glownej, wiec lista zawiera tylko jeden wpis
                    AppendToXML(_class, Component.BLELearning.Statistic.CompetenceStatistic.Restore(_class, CompetenceID)); 

                    // tutaj lista kompetencji skladowych posumowana dla danej kompetencji glownej wkontekscie calej klasy
                    // rozbicje poziomow trudnosci w metodzie AppendToXML
                    AppendToXML(_class, Component.BLELearning.Statistic.CompetencePartStatistic.Restore(_class, CompetenceID)); 
                }
            }

            public override bool Save()
            {
                return true;
            }
        }
    }
}